 /* '01 Main.cpp' */

 /* Nagwek szkieletu okna Mirus */
#include "mrWindow.h"
 /* Nagwek Direct3D */
#include <d3d8.h>

 /* Wasna klasa potomna  */
class D3DWindow : public mrWindow
{
  /* Interfejsy Direct 3D  */
 LPDIRECT3D8             m_pD3D;
 LPDIRECT3DDEVICE8       m_pD3DDevice;
public:
  /* Konstruktor / Destruktor */
 D3DWindow (void) {};
 ~D3DWindow (void) {};

  /* Zainicjalizuj i zamknij Direct3D */
 HRESULT SetupDirect3D (void);
 HRESULT KillDirect3D (void);

  /* Funkcje manipulacji oknami */
 mrBool32 Frame (void);
};

 /* Incjalizuje Direct3D */
HRESULT D3DWindow::SetupDirect3D (void)
{
  /* Tworzy obiekt Direct3D */
 if (NULL == (m_pD3D = Direct3DCreate8 (D3D_SDK_VERSION) ) )
 {
  return E_FAIL;
 }
 
  /* Pobiera biecy tryb ekranu, aby znana bya glbia 
     kolorw */
 D3DDISPLAYMODE d3ddm;
 if (FAILED (m_pD3D->GetAdapterDisplayMode (D3DADAPTER_DEFAULT, 
                                            &d3ddm) ) )
 {
  return E_FAIL;
 }
 
  /* Wprowadzanie parametrw prezentacji */
 D3DPRESENT_PARAMETERS d3dpp; 
 ZeroMemory( &d3dpp, sizeof(d3dpp) );
  /* Wybieramy tryb niepenoekranowy */
 d3dpp.Windowed   = TRUE;
  /* To odrzucamy */
 d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
  /* Zapisujemy format jako format biecy
     (pobieramy go z g_pD3D->GetAdapterDisplayMode)  */
 d3dpp.BackBufferFormat = d3ddm.Format;
 
  /* Tworzenie urzdzenia */
 if (FAILED (m_pD3D->CreateDevice (D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL,
                                   m_hWindow, 
                                   D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                                   &d3dpp, 
                                   &m_pD3DDevice ) ) )
 {
  return E_FAIL;
 }

 return D3D_OK;
}

 /* Zamyka Direct3D */
HRESULT D3DWindow::KillDirect3D (void)
{
   /* Jeeli istniej jakie obiekty Direct3D, uwolnij je */
 if ( NULL != m_pD3D)
 {
  m_pD3D->Release ();
 }
 if ( NULL != m_pD3DDevice)
 {
  m_pD3DDevice->Release ();
 }

 return D3D_OK;

}

 /* Zeruje ekran na kolor niebieski */
mrBool32 D3DWindow::Frame (void)
{
  /* Wypenia okna kolorem niebieskim */
 m_pD3DDevice->Clear (0, NULL, D3DCLEAR_TARGET, 
                      D3DCOLOR_XRGB (0,0,255), 1.0f, 0);

  /* Rozpoczyna renderowanie */
 m_pD3DDevice->BeginScene();
 m_pD3DDevice->EndScene();

  /* Wywietla zrenderowany obraz na ekranie */
 m_pD3DDevice->Present (NULL, NULL, NULL, NULL);

 return mrTrue;
}

 /* "WinMain kontra main" */
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInst, 
                    LPSTR lpCmdLine, int nShowCmd)
{
  /* Nasze okno */
 D3DWindow  kWindow;

  /* Tworzenie okna */
 kWindow.Create (hInstance, "Init and Shutdown");

  /* Ustawienie Direct3D */
 kWindow.SetupDirect3D ();

  /* Wejcie w ptl komunikatw */
 kWindow.Run ();

  /* Zamknicie Direct3D */
 kWindow.KillDirect3D ();

 return 0;
}